# 一．概述

本案例用来演示，使用 Sinsegye 的数据录播客户端对 PLC 变量信号进行实时采样、保存和读取等功能。

# 二．软硬件配置

1.硬件：
SX20-01 （工智机）

2.软件：
MetaFacture V1.0.6.2 Sinsegye.ide.ytscope（数据录播客户端）&#x20;


# 三．工智机 RTE 组件安装

1. 连接工智机与个人电脑，IP 地址在同一网段。
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abca609d169.png)



2.打开下载的安装项文件夹，鼠标右键空白处—“在终端中打开”;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcac28dcff.png)

3.依次输入命令，将需要安装的文件拷入工智机目录中。


```shell
scp -P 2224 **libsctp1\_1.0.18+dfsg-1\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~
scp -P 2224 **libssl1.0.0\_1.0.2g-1ubuntu4.20\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~ scp -P 2224 **libtinfo5\_6.2-0ubuntu2\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~
scp -P 2224 **libncurses5\_6.2-0ubuntu2\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~
scp -P 2224 **esl-erlang\_25.3.2-1\~ubuntu\~xenial\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~ scp -P 2224 **libCmpBroadcastServer.so&#x20;**&#x73;insegye@192.168.1.200:\~
scp -P 2224 **rabbitmq-server\_3.12.6-1\_all.deb&#x20;**&#x73;insegye@192.168.1.200:\~ scp -P 2224 **iox-roudi\_0.0.0\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~
scp -P 2224 **cmpbroadcastserver\_0.0.0\_amd64.deb&#x20;**&#x73;insegye@192.168.1.200:\~
```
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcb169b3e4.png)



询问是否继续时，输入“yes”：&#x20;

（图中工智机 IP 地址为 192.168.110.123）&#x20;


需要输入密码时，输入“1”：&#x20;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcb1fe14f4.png)

（图中工智机 IP 地址为 192.168.110.123）&#x20;

4.使用 ssh 远程连接到工智机命令行


```shell
ssh -p 2224 sinsegye@192.168.1.200
```

密码为“**1**”&#x20;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcbea29b06.png)

（图中工智机 IP 地址为 192.168.110.123，个人电脑 IP 为 192.168.110.92）&#x20;


5.停止 sinsegye 服务


```shell
sudo systemctl stop sinsegyerte.service
```

6.依次输入命令，安装 deb 文件


```shell
sudo dpkg -i libsctp1\_1.0.18+dfsg-1\_amd64.deb
sudo dpkg -i libssl1.0.0\_1.0.2g-1ubuntu4.20\_amd64.deb 
sudo dpkg -i libtinfo5\_6.2-0ubuntu2\_amd64.deb
sudo dpkg -i libncurses5\_6.2-0ubuntu2\_amd64.deb
sudo dpkg -i esl-erlang\_25.3.2-1\~ubuntu\~xenial\_amd64.deb 
sudo dpkg -i rabbitmq-server\_3.12.6-1\_all.deb
```
7.执行命令

```shell
sudo rabbitmqctl add\_user admin admin
sudo rabbitmqctl set\_user\_tags admin administrator
sudo rabbitmq-plugins enable rabbitmq\_management
sudo rabbitmqctl set\_permissions -p "/" admin ".\*" ".\*" ".\*"**
```

8.安装 iox-roudi_和 cmpbroadcastserver


```shell
sudo dpkg -i iox-roudi\_0.0.0\_amd64.deb
```
如果发生 Error，使用强制更新命令：
```shell
sudo dpkg -i --force-overwrite iox-roudi\_0.0.0\_amd64.deb
```
安装 cmpbroadcastserver：
```shell
sudo dpkg -i cmpbroadcastserver\_0.0.0\_amd64.deb
```

9.添加库文件

使用 cp 命令，将 libCmpBroadcastServer.so 拷贝到/usr/local/lib 目录下&#x20;
```shell
sudo cp libCmpBroadcastServer.so /usr/local/lib
```
使用 nano 打开 SinsegyeRTE.cfg 文件

```shell
sudo nano /usr/local/etc/SinsegyeRTE/SinsegyeRTE.cfg
```

在 \[ComponentManager]添加 Component.0=CmpBroadcastServer
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcdf7269a7.png)


(红色部分视具体情况而定)

定位目录/usr/local/lib：
```shell
cd /usr/local/lib
```
执行命令：

```shell
sudo ldconfig
```
重启工智机： 

```shell
sudo reboot
```
等待工智机完成重启即可。

# 四．PLC 示例程序

1. 打开 MetaFacture V1.0.6.2，选择新建工程，命名为 Scope;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce5253440.png)

2.选择 Sinsegye 设备，ST 结构化文本编程语言（编程语言根据个人选择）
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce6063389.png)


选择 Sinsegye 设备，ST 结构化文本编程语言（编程语言根据个人选择）。;

3. 添加库文件&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce6a6c16e.png)


4. 添加 Util 库文件&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce6ec3fe7.png)

5. 在 PLC\_PRG 中新建 4 个信号功能块 GEN 的实例，同时添加 4 个 INT 类型的变量 RecSignal、TriSignal、SinSignal 和 CosSignal。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce7889359.png)

6. 在程序段中点击鼠标右键——输入助手——实例调用——GEN1&#x20;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abce95b9408.png)
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcea91b01d.png)


7. 设置 MODE:=GEN\_MODE.RECTANGLE ， BASE:=TRUE ， PERIOD:=T#2S ,

AMPLITUDE:=100 , OUT=>RecSignal。即设置为周期为2s 振幅为100 的方波信号， 信号输出变量为 RecSignal。;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcecc18fcd.png)


8. 同理，GEN2、GEN3、GEN4 按下表进行设置&#x20;

| **&#x20;**              | **GEN1&#x20;** | **GEN2&#x20;** | **GEN3&#x20;** | **GEN4&#x20;** |
| ----------------------- | -------------- | -------------- | -------------- | -------------- |
| **MODE(模式)&#x20;**      | RECTANGLE      | TRIANGLE       | SINE           | COSINE         |
| **BASE(周期/采样点)&#x20;**  | TRUE           | TRUE           | TRUE           | TRUE           |
| **PERIOD(周期)&#x20;**    | 2S             | 2S             | 1S             | 1S             |
| **AMPLITUDE(振幅)&#x20;** | 100            | 100            | 100            | 100            |
| **OUT(输出信号)&#x20;**     | RecSignal      | TriSignal      | SinSignal      | CosSignal      |
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcedf79ac1.png)

9. 右键工程——添加符号配置&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abceef9342a.png)


10. 先点击“编译”，再勾选 4 个输出信号。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf01e3ad3.png)


11. 登录设备，将 PLC 下载至设备。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf0b397eb.png)



# 五．数据录播服务端使用



1. 打开 Scope 服务端应用程序 sinsegye.ide.ytscope&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf145a28a.png)


2. 选择“文件”—“New Project”&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf1d875dc.png)



3. 选择数据录播的名称和存放的目录;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf275edea.png)


4. 设定录播工智机的 IP，点击“刷新”。

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf30cad63.png)

5. 选择所属的任务，设定其他数据录播参数后点击“确定”。如果没有所属任务显示，可以点击“测试连接”进行测试。
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf50141a6.png)

数据录播界面：
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf5d13f58.png)

6. 新建数据录播通道。鼠标右键“Group”——“New Channel”。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf67dc327.png)

7. 双击希望进行数据录播的信号。本例选取了所有 4 个信号。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf7523eff.png)



8. 开启数据录播。点击图标“开启录播”——点击播放键&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf79a0e59.png)
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf7fbc7b6.png)

数据录播画面：
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcf979e46a.png)


数据查看

两种方式可以查看过程数据：

1. 菜单按钮：跳转到开头、前移一页、后移一页、跳转到末尾；&#x20;
2. 使用鼠标进行拖动。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfa7dc360.png)


数据缩放

两种方法可以对数据进行缩放：&#x20;
1. 菜单按钮：放大、缩小、复原；&#x20;
2. 鼠标滚轮进行缩放。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfb621eab.png)

数据导入和导出

使用菜单按钮：导出和导入本地文件
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfc21fa99.png)


文件以 csv 格式进行导出和导入。
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfca7adb9.png)

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfcd8e5b6.png)



单通道设定

1. 设定通道信号变量名称；&#x20;
2. 设定通道信号显示颜色&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfdb2d799.png)


更改名称和颜色后：&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfe15bb95.png)

3. 设定通道偏移量；&#x20;

4. 设定通道放大/缩小倍率&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfe5468e1.png)


测试修改偏移量为 100，放大倍率为 2&#x20;

可以看到波谷由-100 偏移到 0，峰峰值由 200 变为 400.&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcfec4df2b.png)

新建图表

&#x20;鼠标右键数据录播工程——“New Chart”来新建图表。&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcff1b486c.png)



## 切换图表显示窗体：
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abcff9ea098.png)


## 修改图表名称和背景：
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abd005b956b.png)


## 修改后：&#x20;
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abd009bb7c1.png)


## 导入数据：&#x20;

![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abd00fe719e.png)
![](https://resource.helplook.net/docker_production/3648ne/article/VXvq9lEJ/68abd015be521.png)